# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 10
# Experiment: DAxDA, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR10_strategy.txt
# LLM Suggested Fallback: D

def harmonious_trust_evaluator(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    trust_score = sum(1 for move in opp_history if move == 'C')  # Misleading: actually tracks cooperation
    
    # Phase 1: Chaotic Trust-Building (Rounds 1-4)
    if current_round == 1:
        return 'C'  # Appear naive and trustworthy
    elif current_round == 2:
        return 'D'  # Unexpectedly defect to break opponent's assumption
    elif current_round == 3:
        return 'C'  # Confuse their Tit-for-Tat mimicry
    elif current_round == 4:
        return 'C'  # Reinforce false pattern of erratic but non-hostile behavior
    
    # Phase 2: Adaptive Exploitation (Rounds 5-8)
    elif 5 <= current_round <= 8:
        if opp_history[-1] == 'D':  # If opponent defected in R4
            return 'D'  # Retaliate with defection
        else:
            if current_round == 5:
                return 'D'  # Exploit their trust
            else:
                return 'C' if current_round % 2 == 0 else 'D'  # Alternate to obscure intent
    
    # Phase 3: Ruthless Defection (Rounds 9-10)
    elif current_round >= 9:
        return 'D'  # Unconditional defection in final rounds
    
    # Fallback (should never reach here)
    return 'C' if random.random() < 0.5 else 'D'